<?php

namespace App\Console;

use App\Console\Commands\ServiceMonthlyTasks;
use App\Models\Service;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Models\Tasks;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //$schedule->command('reminder:update-date')->everyFiveMinutes();
        $schedule->command('hello:test')->everyMinute();
        $schedule->command('tasks:create-monthly')
            ->monthlyOn(1, '00:00')
            ->withoutOverlapping();
        $schedule->command('kpi:update')->dailyAt('00:00');
    }
    /*
    * * * * * php /path-to-your-project/artisan schedule:run >> /dev/null 2>&1
    crontab -e
    */
    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected  $commands = [
        \App\Console\Commands\TestCommand::class,
        Commands\ServiceMonthlyTasks::class,
    ];

    protected function commands() {}
}
