<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ClientsService extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'client_services';

    protected $fillable = [
        'clients_id',
        'services_id',
        'service_repeat',
        'schedule_start',
        'schedule_end',
        'status'
    ];

    public function client()
    {
        return $this->belongsTo(Client::class, 'clients_id', 'id');
    }
    // relation between service and clientservice
    public function service()
    {
        return $this->hasOne(Service::class, 'id', 'services_id');
    }
    public function cservice()
    {
        return $this->belongsTo(Service::class, 'services_id', 'id');
    }

    public function taskService()
    {
        return $this->hasOne(Service::class, 'id');
    }

    public function serv()
    {
        return $this->hasOne(Service::class, 'id');
    }


    public function cs_service(): HasOne
    {
        return $this->hasOne(Client::class);
    }
}
