<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentDispatchJob extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'document_dispatch_jobs';

    protected $fillable = [
        'client_name',
        'dispatchCreator',
        'dispatch_no',
        'dispatch_attachment'
    ];
    public function client()
    {
        return $this->belongsTo(Client::class, 'id');
    }
}
