<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CheckInTime extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'check_in_time';

    protected $fillable = [
        'checked_in_time',
        'user_id',
    ];
    public function employeeAtt()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function checkOutTime()
    {
        return $this->hasOne(CheckOutTime::class, 'user_id', 'user_id');
    }
}
