<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Task_Post extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'task_post';

    protected $fillable = [
        'user_id',
        'post',
        'task_id'
    ];
    public function likes()
    {
        return $this->hasMany(Task_likes::class);
    }
    public function comments()
    {
        return $this->hasMany(Task_Comments::class);
    }
    public function taskpost()
    {
        return $this->belongsTo(Tasks::class);
    }
    public function postuser()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
