<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'phone',
        'role_id',
        'password',
        'profile_image',
        'first_name',
        'middle_name',
        'last_name',
        'status',
        'position',
        'cv',
        'contract',
        'application',
        'offer_letter',
        'nssf',
        'enddate',
        'phone',
        'joining_date',
        'start_date',
        'termination',
        'enddate',
        'termination_letter',
        'contract_period',
        'tin',
        'nida'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function roleuser(): HasOne
    {
        return $this->hasOne(Role::class, 'id', 'role_id');
    }
    public function employeeUser()
    {
        return $this->hasOne(Employee::class, 'user_id');
    }
    public function userAssign()
    {
        return $this->belongsTo(Tasks::class, 'user_id');
    }
    public function assignedUser()
    {
        return $this->hasMany(Tasks::class, 'user_id', 'id');
    }
    public function comments()
    {
        return $this->hasMany(Task_Comments::class, 'user_id');
    }
}
