<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prechecks extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'service_prechecks';

    protected $fillable = [
        'service_id',
        'name',
        'note',
        'multiple_upload',
        'mandatory',
        'description'
    ];
    public function preChecklist()
    {
        return $this->hasOne(Precheck_Attachment::class);
    }
    public function attachments()
    {
        return $this->hasOne(Precheck_Attachment::class, 'serviceprecheck_id', 'id');
    }
}
