<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Task_Comments extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'task_comments';

    protected $fillable = [
        'user_id',
        'comments',
        'taskpost_id',
        'task_id'
    ];

    public function commentUser()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
    public function commuser()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
